using System;

public abstract class Window
{
	// Konstruktor przyjmuje dwie liczby cakowite, 
	// aby okreli pooenie konsoli
	public Window(int top, int left)
	{
		this.top = top;
		this.left = left;
	}

	// Symulacja rysowania okna.
	// Uwaga  brak implementacji
	public abstract void DrawWindow();

	protected int top;
	protected int left;
} // Koniec Window

// Klasa ListBox dziedziczy po klasie Window
public class ListBox : Window
{
	// Konstruktor ma nowy parametr 
	public ListBox(
	   int top,
	   int left,
	   string contents)
		: base(top, left) // Wywoanie konstruktora klasy bazowej
	{
		listBoxContents = contents;
	}

	// Przesaniajca wersja z implementacj
	// metody abstrakcyjnej
	public override void DrawWindow()
	{
		Console.WriteLine("Zapis acucha znakw do kontrolki klasy ListBox: {0}",
		   listBoxContents);
	}
	private string listBoxContents; // Nowa zmienna skadowa
} // Koniec ListBox

public class Button : Window
{
	public Button(
	   int top,
	   int left)
		: base(top, left) { }

	// Implementacja metody abstrakcyjnej
	public override void DrawWindow()
	{
		Console.WriteLine("Rysowanie przycisku w punkcie {0}, {1}\n",
		   top, left);
	}
} // Koniec Button

public class Tester
{
	static void Main()
	{
		Window[] winArray = new Window[3];
		winArray[0] = new ListBox(1, 2, "Pierwsza kontrolka klasy ListBox");
		winArray[1] = new ListBox(3, 4, "Druga kontrolka klasy ListBox");
		winArray[2] = new Button(5, 6);

		for (int i = 0; i < 3; i++)
		{
			winArray[i].DrawWindow();
		} // Koniec for
	} // Koniec main
} // Koniec Tester
